<?php

namespace App\Modules\Finance\Models\Monolith;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class ClubLocation extends Model
{
    use HasFactory;

    protected $connection = 'external_db';

    public $timestamps = false;

    protected $fillable = [
        'club_id',
        'name',
        'slug',
        'description',
        'phone',
        'email',
        'address',
        'slug',
        'latitude',
        'longitude',
        'photos',
        'worktime_start',
        'worktime_end',
        'game_types',
        'custom_logo',
        'custom_name'
    ];

    protected $casts = [
        'photos' => 'array',
    ];

    protected $hidden = [
        'playtomic_uuid',
        'playtomic_parse_active',
    ];

    public function club()
    {
        return $this->belongsTo(Club::class);
    }




}

