<?php

namespace App\Modules\Finance\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\Blog\Models\Category;
use App\Modules\Finance\Http\Resources\ClubResource;
use App\Modules\Finance\Http\Resources\LocationResource;
use App\Modules\Finance\Models\Monolith\Club;
use App\Modules\Finance\Models\Monolith\ClubLocation;
use Illuminate\Http\Request;


class FinanceController extends Controller
{
    public function getClubs(Request $request)
    {
        $query = Club::query();

        // Фильтрация по ID
        if ($request->filled('id')) {
            $query->where('id', $request->input('id'));
        }

        // Фильтрация по name
        if ($request->filled('name')) {
            $query->where('name', 'like', '%' . $request->input('name') . '%');
        }

        // Пагинация или получение всех записей
        $clubs = $request->has('page')
            ? $query->paginate($request->input('per_page', config('app.per_page', 2)))
            : $query->get();

        return response()->success('Clubs list received successfully', ClubResource::collection($clubs));
    }

    public function getClub($club_id)
    {
        if ($club_id != null  || $club_id != 0) {
            $club = Club::find($club_id);
        } else {
            return response()->errorNotFound('Club not found');
        }

        return response()->success('Club retrieved successfully', new ClubResource($club));
    }


    public function getLocationByClubId($club_id, Request $request)
    {
        $query = ClubLocation::query();

        if ($club_id) {
            $query->where('club_id', $club_id);
        }

        if ($request->has('page')) {
            $perPage = $request->input('per_page', config('app.per_page', 2));
            $locations = $query->paginate($perPage);
        } else {
            $locations = $query->get();
        }

        if ($locations->isEmpty()) {
            return response()->errorNotFound('Club locations not found');
        }
        return response()->success('Location list received successfully', LocationResource::collection($locations));
    }


}
