<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->enum('status', ['DRAFT', 'PUBLISH', 'ARCHIVE'])->default('DRAFT');
            $table->timestamp('publish_date')->nullable();
            $table->string('slug')->unique();
            $table->string('page_header')->nullable();
            $table->text('page_description')->nullable();
            $table->string('page_og_image')->nullable();
            $table->string('author')->nullable();
            $table->longText('content_body')->nullable(); // Для JSON контента
            $table->json('tag_ids')->nullable(); // Хранение идентификаторов тегов
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('cascade'); // Связь с category
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
