<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class MakeModule extends Command
{
    protected $signature = 'make:module {name}';
    protected $description = 'Create a new module with its folder structure';

    public function handle()
    {
        $moduleName = $this->argument('name');
        $modulePath = app_path("Modules/{$moduleName}");

        if (File::exists($modulePath)) {
            $this->error("Module {$moduleName} already exists!");
            return 1;
        }

        $directories = [
            'Http/Controllers',
            'Http/Requests',
            'Http/Resources',
            'Models',
            'Events',
            'Exceptions',
            'Listeners',
            'Mail',
            'Policies',
            'Providers',
            'Services',
            'database/migrations',
            'database/seeders',
            'config',
            'routes',
        ];

        foreach ($directories as $directory) {
            File::makeDirectory("{$modulePath}/{$directory}", 0755, true);
        }

        File::put("{$modulePath}/routes/api.php", "<?php\n\n// API routes for {$moduleName}");

        $this->info("Module {$moduleName} created successfully!");

        return 0;
    }
}
